module tileXY_cl_intf #(IDX) (
  input clk,
  input rst,
  input [4:0] tile_X,
  input [4:0] tile_Y,
  input [15:0] rnd,
  input in_en,
  input [66*8-1:0] in_datum, 
  input [36:0] in_addr,
  input [41:0] insize,//{shared,exclusive,phymsk}
  output reqmort_expun,
  output [66*8-1:0] reqmort_data,
  output [3:0][36:0] reqmortaddr,
  output [44:0] reqmort_size,
//  output reqmort_flush_only,
  output outen,
  input nomissex,
  input [38:0] missue_addr,
  input [39:0] missue_phy,
  input data_in_en,
  input dataF_in_en,
  input [`wrreq_size-1:0] dataF,
  input [43:6] lraddr,
  input lren,
  output data_stall);
    import "DPI-C" function int getmemstall();
  memblkstd mem(
  clk,
  rst,
  memstall,
  random,  
  missue_addr,
  missue_phy,
  {fwd,in_datumx},
  missue_en,
  reqmort_addrx,
  reqmort_sizex[40+:5],
  reqmort_sizex[39:0],
  outenx,
  in_addr,
  in_datum,
  in_en,
  waddr_out,
  wren,
  tileX,
  tileY,
  PHY
);
wire mstall1;
assign in_datum =qitop? qdata[itop]: in_datumx;
assign reqmort_addr =qitop? qaddr[itop]: reqmort_addrx;
assign reqmort_size =qitop? qsize[itop]: reqmort_sizex;
assign outen=qitop||outenx;
always @* data_stall=getmemstall() | ~mstall1;
bit_find_index12 a(qen,itop,,qitop);
bit_find_index12 b(~qin&~qen,ifind,,mstall1);
  always @(posedge clk) begin
      if (outenx(outenx) && isfwd(in_datumx[66*8+:10]) | qitop) begin
          qaddr[ifind]<=reqmort_addrx;
          qsize[ifind]<=reqmort_sizex;
          qdata[ifind]<=in_datumx;
          qin[ifind]<=1;
          coresend(reqmort_addrx,tile_X,tile_Y,reqmort_addrx[36:31]);
      end
      newaddr={corerecvs(),corerecva()};
      newdata=corerecvd();
      newphy=corerecvphy();
      newen=corerecv();
      for(p=0;p<12;p++) begin end
          if (qin[p] && qaddr[p]==newaddr) begin 
              qen[p]=1;
              if (!isbcast(qdata[p][66*8+:10])) qdata[p]=newdata;
              qin[p]=0;
          end
          if (qaddr[itop]==qaddr[p] && qitop) begin 
              qen[p]=0; 
              qin[p]=0;
          end
      end
      
      
      
      
  end
  endmodule 
  
