`define wrreq_data 527:0
`define wrreq_XDONE 528
`define wrreq_YDONE 529
`define wrreq_TX 534:530
`define wrreq_TY 539:535
`define wrreq_sz 579:540
`define wrreq_shared 580
`define wrreq_addr 728:581
`define wrreq_snd 729
`define wrreq_expun 730
`define wrreq_pltpage 733:731
`define wrreq_bcast 734
`define wrreq_size 735
`define wrreq_extra 735

`define wrAreq_data 73:0
`define wrAreq_XDONE 74
`define wrAreq_YDONE 75
`define wrAreq_TX 80:76
`define wrAreq_TY 85:81
`define wrAreq_sz 125:86
`define wrAreq_addr 162:126
`define wrAreq_tx 127:126
`define wrAreq_ty 129:128
`define wrAreq_txu 162:160
`define wrAreq_tyu 159:157
`define wrAreq_snd 163
`define wrAreq_size 164
`define wrAreq_extra 164

`define range_Y [3:2]
`define range_X [1:0]
`define rng_X [1:0]
`define rng_Y [1:0]
`define range_address [36:4]
module tile_single_fifo #(parameter WIDTH=32)(
  input clk,
  input rst,
  input [WIDTH-1:0] data_in,
  output [WIDTH-1:0] data_stop,
  output [WIDTH-1:0] data_out,
  input data_in_en,
  input dataF_in_en,
  input [WIDTH-1:0] dataF,
  input [WIDTH-1:0] data_in2,
  input [WIDTH-1:0] data_in3,
  input data_in2_en,
  input data_in3_en,
  output data_stall,
  input stall_in);
  
  reg [7:0][WIDTH-1:0] queue;
  reg [2:0] q_in;
  reg [2:0] q_out;
  
  assign data_out=q_in==q_out ? '0 : queue[q_in];
  
  always @(posedge clk) begin

    if (data_in_en) begin
        queue[q_out]=data_in;
        q_out=q_out+1;
    end
    if (data_in2_en) begin
        queue[q_out]=data_in2;
        q_out=q_out+1;
    end
    if (data_in3_en) begin
        queue[q_out]=data_in3;
        q_out=q_out+1;
    end
    if (dataF_in_en) begin
        queue[q_out]=dataF_in;
        q_out=q_out+1;
    end
    if (rst) begin
        q_in<=0;
        q_out<=0;
    end
  end
endmodule
module tile_single_fifo3 #(parameter WIDTH=32)(
  input clk,
  input rst,
  input [WIDTH-1:0] data_in,
  input [WIDTH-1:0] data_in2,
  input [WIDTH-1:0] data_in3,
  input [WIDTH-1:0] data_in4,
  input data_in3_en,
  input data_in4_en,
  output [WIDTH-1:0] data_stop,
  output [WIDTH-1:0] data_out,
  input data_in_en,
  input data_in2_en,
  input dataF_in_en,
  input [WIDTH-1:0] dataF,
  output data_stall,
  input stall_in);
  
  reg [7:0][WIDTH-1:0] queue;
  reg [2:0] q_in;
  reg [2:0] q_out;
  
  assign data_out=q_in==q_out ? '0 : queue[q_in];
  
  always @(posedge clk) begin

    if (data_in_en) begin
        queue[q_out]=data_in;
        q_out=q_out+1;
    end
    if (data_in2_en) begin
        queue[q_out]=data_in2;
        q_out=q_out+1;
    end
    if (data_in3_en) begin
        queue[q_out]=data_in3;
        q_out=q_out+1;
    end
    if (data_in4_en) begin
        queue[q_out]=data_in4;
        q_out=q_out+1;
    end
    if (dataF_in_en) begin
        queue[q_out]=dataF_in;
        q_out=q_out+1;
    end
    if (rst) begin
        q_in<=0;
        q_out<=0;
    end
  end
endmodule
module tile_single_fifo4 #(parameter WIDTH=32)(
  input clk,
  input rst,
  input [3:0][WIDTH-1:0] data_in,
  input [WIDTH-1:0] data_in2,
  output [WIDTH-1:0] data_stop,
  output [WIDTH-1:0] data_out,
  input [3:0] data_in_en,
  input data_in2_en,
  output data_stall,
  input stall_in);
  
  reg [7:0][WIDTH-1:0] queue;
  reg [2:0] q_in;
  reg [2:0] q_out;
  integer k;
  
  assign data_out=q_in==q_out ? '0 : queue[q_in];
  
  always @(posedge clk) begin
    for(k=0;k<4;k=k+1)
    if (data_in_en[k]) begin
        queue[q_out]=data_in[k];
        q_out=q_out+1;
    end
    if (data_in2_en) begin
        queue[q_out]=data_in2;
        q_out=q_out+1;
    end
    if (rst) begin
        q_in<=0;
        q_out<=0;
    end
  end
endmodule
module tileXY_cl_fifo #(IDX) (
  input clk,
  input rst,
  input [4:0] tile_X,
  input [4:0] tile_Y,
  input [15:0] rnd,
  input [3:0][`wrreq_size:0] X_intf_in, 
  output [3:0][`wrreq_size:0] X_intf_out,
  input [3:0][`wrAreq_size:0] XA_intf_in, 
  output [3:0][`wrAreq_size:0] XA_intf_out,
  input in_en,
  input [66*8-1:0] in_datum, 
  input [36:0] in_addr,
  input [41:0] insize,//{shared,exclusive,phymsk}
  output reqmort_expun,
  output [66*8-1:0] reqmort_data,
  output [3:0][36:0] reqmortaddr,
  output [44:0] reqmort_size,
//  output reqmort_flush_only,
  output outen,
  input nomissex,
  input [38:0] missue_addr,
  input [39:0] missue_phy,
  output fiq_en,
  output [36:0] fiq_addr,
  output fiq_want_shared,
  output fiq_want_exclusive,
  output fiq_wb,
  input [8*66-1:0] fiq_data,
  output [8*66-1:0] fiq_data_out,
  input [39:0] fiq_phy,
  output [39:0] fiq_phy_fwd,
  input  fiq_en_in,
  input fiq_fwd,
  input fiq_bcast,
  output [9:0] fiq_srcXY,
  input [9:0] fiq_srcXY_in,
  input [2:0] fiq_pltpage,
  input [9:0] fiq_fwd_XY,
  input [3:0][36:0] fiq_addr_fwd,
  input data_in_en,
  input dataF_in_en,
  input [`wrreq_size-1:0] dataF,
  input [43:6] lraddr,
  input lren,
  output data_stall);
  
  wire [`wrreq_size-1:0] wrreq;
  wire [`wrreq_size-1:0] wb_wrreq;
  wire [3:0] xcross_AL_enA;
  wire [3:0] xcross_DL_enA;
  wire [3:0] xcross_AL_enB;
  wire [3:0] xcross_DL_enB;
  wire dataFIQD_stall,dataFIQ_stall;
  wire data_stop_DL_match,data_stop_AL_match;
  wire [`wrreq_size:0] fiq_data_req;
  generate
    genvar k;
    for(k=0;k<4;k=k+1) begin : LRUD
        tile_single_fifo #(`wrAreq_size) AL_fifo (
        clk,rst,
        XA_intf_in[k],
        data_stop_AL[k],
        XA_intf_out[k],
        XA_intf_in[k][`wrAreq_snd],
        wrAreq_new[k],
        wrAreq,
        data_stop_AL[k^2],
        data_sop_AL[k^3],
        xcross_AL_enA[k],
        xcross_AL_enB[k],
        stall[k]);
        assign data_stop_ALx[`wrreq_data]='0;
        assign data_stop_ALx[`wrreq_XDONE]=data_stop_AL[`wrAreq_XDONE];
        assign data_stop_ALx[`wrreq_YDONE]=data_stop_AL[`wrAreq_YDONE];
        assign data_stop_ALx[`wrreq_TX]=data_stop_AL[`wrAreq_TX];
        assign data_stop_ALx[`wrreq_TY]=data_stop_AL[`wrAreq_TY];
        assign data_stop_ALx[`wrreq_sz]=data_stop_AL[`wrAreq_sz];
        assign data_stop_ALx[`wrreq_shared]=1'b0;
        assign data_stop_ALx[`wrreq_addr]=data_stop_AL[`wrAreq_addr];
        assign data_stop_ALx[`wrreq_snd]=data_stop_AL[`wrAreq_snd];
        assign data_stop_ALx[`wrreq_expun]=1'b0;
        assign data_stop_ALx[`wrreq_pltpage]=3'b0;
        assign data_stop_ALx[`wrreq_extra]=1'b0;
       
        tile_single_fifo3 #(`wrreq_size) DL_fifo (
        clk,rst,
        X_intf_in[k],
        wb_wrreq,
        data_stop_DL[k^2],
        data_stop_DL[k^3],
        xcross_DL_enA[k],
        xcross_DL_enB[k],
        data_stop_DL[k],
        X_intf_out[k],
        X_intf_in[k][`wrreq_snd],
        wb_wrreq[`wrreq_snd],
        wrreq_new[k],
        wrreq[`wrreq_snd],
        wrreq,
        stall_D[k]);
    end
  endgenerate
  tile_single_fifo4 #(`wrreq_size+1) fiq_queue(
  clk,rst,
  data_stop_ALx,
  data_wbinm2,
  fiq_data_req,
  ,
  data_stop_AL_match,
  {1'b1,data_en_wbinm2},
  dataFIQ_stall);

  tile_single_fifo4 #(`wrreq_size) fiq_queue2(
  clk,rst,
  data_stop_DL,
  '0,
  data_wbinm,
  ,
  data_stop_DL_match,
  1'b0,
  dataFIQD_stall);
  
  assign wrreq[`wrreq_data]=fiq_data;
  assign wrreq[`wrreq_XDONE]=(fiq_fwd ? fiq_fwd_XY[4:0] : fiq_srcXY_in[4:0])==tile_X;
  assign wrreq[`wrreq_YDONE]=(fiq_fwd ? fiq_fwd_XY[9:5] : fiq_srcXY_in[9:5])==tile_Y;
  assign wrreq[`wrreq_TX]=fiq_fwd ? fiq_fwd_XY[4:0] : fiq_srcXY_in[4:0];
  assign wrreq[`wrreq_TY]=fiq_fwd ? fiq_fwd_XY[9:5] : fiq_srcXY_in[9:5];
  assign wrreq[`wrreq_sz]=fiq_phy;
  assign wrreq[`wrreq_shared]=fiq_addr_fwd[37];
  assign wrreq[`wrreq_addr]=fiq_addr_fwd[36:0];
  assign wrreq[`wrreq_snd]=fiq_en_in;
  assign wrreq[`wrreq_expun]=fiq_bcast;
  assign wrreq[`wrreq_pltpage]=fiq_pltpage;
  
  assign wrreq_new={4{fiq_en_in}} & ({{2{fiq_bcast}},2'b0} | {wrreq[`wrreq_TX]<tile_X && wrreq[`wrreq_YDONE]|rnd[0],wrreq[`wrreq_TX]>tile_X && wrreq[`wrreq_YDONE]|rnd[0],
    wrreq[`wrreq_TY]<tile_Y && wrreq[`wrreq_XDONE]|~rnd[0],wrreq[`wrreq_TY]>tile_Y && wrreq[`wrreq_XDONE]|~rnd[0]});
 
  assign xcross_DL_enA[0]=data_stop_DL[2][`wrreq_snd] && data_stop_DL[2][`wrreq_bcast] | (data_stop_DL[`wrreq_TX]==tile_X) && data_stop_DL[2][`wrreq_TY]>tile_Y;
  assign xcross_DL_enB[0]=data_stop_DL[3][`wrreq_snd] && data_stop_DL[3][`wrreq_bcast] | (data_stop_DL[`wrreq_TX]==tile_X) && data_stop_DL[3][`wrreq_TY]>tile_Y;
  assign xcross_DL_enB[1]=data_stop_DL[2][`wrreq_snd] && data_stop_DL[2][`wrreq_bcast] | (data_stop_DL[`wrreq_TX]==tile_X) && data_stop_DL[2][`wrreq_TY]<tile_Y;
  assign xcross_DL_enA[1]=data_stop_DL[3][`wrreq_snd] && data_stop_DL[3][`wrreq_bcast] | (data_stop_DL[`wrreq_TX]==tile_X) && data_stop_DL[3][`wrreq_TY]<tile_Y;
  assign xcross_DL_enA[2]=data_stop_DL[0][`wrreq_snd] && data_stop_DL[0][`wrreq_bcast] | (data_stop_DL[`wrreq_TY]==tile_Y) && data_stop_DL[2][`wrreq_TX]>tile_X;
  assign xcross_DL_enB[2]=data_stop_DL[1][`wrreq_snd] && data_stop_DL[1][`wrreq_bcast] | (data_stop_DL[`wrreq_TY]==tile_Y) && data_stop_DL[3][`wrreq_TX]>tile_X;
  assign xcross_DL_enB[3]=data_stop_DL[0][`wrreq_snd] && data_stop_DL[0][`wrreq_bcast] | (data_stop_DL[`wrreq_TY]==tile_Y) && data_stop_DL[2][`wrreq_TX]<tile_X;
  assign xcross_DL_enA[3]=data_stop_DL[1][`wrreq_snd] && data_stop_DL[1][`wrreq_bcast] | (data_stop_DL[`wrreq_TY]==tile_Y) && data_stop_DL[3][`wrreq_TX]<tile_X;

  assign xcross_AL_enA[0]=data_stop_AL[2][`wrAreq_snd] && (data_stop_AL[`wrreq_TX]==tile_X) && data_stop_AL[2][`wrreq_TY]>tile_Y;
  assign xcross_AL_enB[0]=data_stop_AL[3][`wrAreq_snd] && (data_stop_AL[`wrreq_TX]==tile_X) && data_stop_AL[3][`wrreq_TY]>tile_Y;
  assign xcross_AL_enB[1]=data_stop_AL[2][`wrAreq_snd] && (data_stop_AL[`wrreq_TX]==tile_X) && data_stop_AL[2][`wrreq_TY]<tile_Y;
  assign xcross_AL_enA[1]=data_stop_AL[3][`wrAreq_snd] && (data_stop_AL[`wrreq_TX]==tile_X) && data_stop_AL[3][`wrreq_TY]<tile_Y;
  assign xcross_AL_enA[2]=data_stop_AL[0][`wrAreq_snd] && (data_stop_AL[`wrreq_TY]==tile_Y) && data_stop_AL[2][`wrreq_TX]>tile_X;
  assign xcross_AL_enB[2]=data_stop_AL[1][`wrAreq_snd] && (data_stop_AL[`wrreq_TY]==tile_Y) && data_stop_AL[3][`wrreq_TX]>tile_X;
  assign xcross_AL_enB[3]=data_stop_AL[0][`wrAreq_snd] && (data_stop_AL[`wrreq_TY]==tile_Y) && data_stop_AL[2][`wrreq_TX]<tile_X;
  assign xcross_AL_enA[3]=data_stop_AL[1][`wrAreq_snd] && (data_stop_AL[`wrreq_TY]==tile_Y) && data_stop_AL[3][`wrreq_TX]<tile_X;
  assign out_en=data_wbinm[`wrreq_snd] && data_wbinm[`wrreq_TX]==tile_X && data_wbinm[`wrreq_TY]==tile_Y;
endmodule

