module memblk(
  input clk,
  input rst,
  output reg stall,
  input [15:0] random,  
  input [38:0] rdaddr0,
  input [39:0] rdphydata0,
  output reg [8*66+4:0] rddata,
  input  rden_in,
  output reg [3:0][36:0] rdaddr,
  output reg  rd_pltpage,
  output reg [39:0] rdphydata,
  output reg  rden_out,
  input [38:0] wraddr0,
  input [8*66+4:0] wrdata,
  input  wren_in,
  output reg [3:0][36:0] wraddr,
  output reg  wren_out,
  input [1:0] tileX,
  input [1:0] tileY
);
  

  reg [63:0][1:0] wsz0_reg;
  reg [63:0][32:0] waddr0_reg;
  reg [3:0][33:0] waddr0_xtra;
  reg [3:0][33:0] waddr0_xtra_reg;
  reg [32:0] waddr0_rexx;
  reg [32:0] waddr0_rexx2;
  reg [63:0][66*8-1:0] wrdata_reg;
  reg [63:0] wren_in_reg;
  reg [63:0][32:0] rdaddr0_reg;
  reg [63:0][39:0] rdphydata0_reg;
  reg [32:0] rdaddr0_rexx;
  reg [32:0] rdaddr0_rexx2;
  reg [3:0][33:0] rdaddr0_xtra;
  reg [3:0][33:0] rdaddr0_xtra_reg;
  reg [63:0] rden_in_reg;
  reg [63:0][32:0] rdaddr_reg;
  reg [63:0][3:0] rdxdata_reg;
  `ifndef production
  //reg [1<<24-1+1<<19:0][66*8-1:0] ram_block;
  //reg [1<<24-1+1<<19:0][4:0] ram_blockx;
  `else
  //reg [1<<25-1+1<<19:0][66*8-1:0] ram_block;
  //reg [1<<25-1+1<<19:0][4:0] ram_blockx;
  `endif//
  import "DPI-C" function int rdram(input int addr, input int piece, input int tx, input int ty);
  import "DPI-C" function int rdramx(input int addr, input int tx, input int ty);
  import "DPI-C" function int wrblockwr(input int addr, input [8*66-1:0] piece, input int tx, input int ty);
  import "DPI-C" function int wrblockx(input int addr, input int piece,input int tx, input int ty); 
  integer rdport;
  integer regcnt;
  integer tlbptr;

  wire rdnshare;
  wire [4*66-1:0] tlbdata;
  wire [4*66-1:0] tlbdataw;
  reg [4*66-1:0] tlbdata_reg;
  reg [4*66-1:0] tlbdataw_reg;
  reg [1:0] stcnt;
  
  `define rng_X [1:0]
  `define rng_Y [1:0]
  
  assign rdnshare=(random&16'h1ff)==16'd5;
  generate
    genvar k;
    for(k=0;k<17;k=k+1) begin
        /* verilator lint_off WIDTHTRUNC */
        assign tlbdata[k*32+:32]=rdram(1<<24+rdaddr0_reg[44][25:6],k,tileX,tileY);
        assign tlbdataw[k*32+:32]=tlbdata[k*32+:32];
        /* verilator lint_on WIDTHTRUNC */

        assign rddata[k*32+:32]={rdramx(rdaddr0_reg[47][24:0],tileX,tileY)[3:0],rdram(rdaddr0_reg[47][24:0],k,tileX,tileY)};
  
    end
  endgenerate
        assign {rd_pltpage,rdaddr[0]}={rdaddr0_xtra[0],tileX`rng_X,tileY`rng_Y};
        assign rdaddr[1]={rdaddr0_xtra[1],tileX`rng_X,tileY`rng_Y};
        assign rdaddr[2]={rdaddr0_xtra[2],tileX`rng_X,tileY`rng_Y};
        assign rdaddr[3]={rdaddr0_xtra[3],tileX`rng_X,tileY`rng_Y};
        assign wraddr[0]={waddr0_xtra[0],tileX`rng_X,tileY`rng_Y};
        assign wraddr[1]={waddr0_xtra[1],tileX`rng_X,tileY`rng_Y};
        assign wraddr[2]={waddr0_xtra[2],tileX`rng_X,tileY`rng_Y};
        assign wraddr[3]={waddr0_xtra[3],tileX`rng_X,tileY`rng_Y};
        assign rden_out=rden_in_reg[47];  
        assign rdphydata=rdphydata0_reg[47];
    stall=stcnt!=2'b0 || !|wren_in_reg[4];
    always @* begin 
    sendaddr(rdaddr0_reg[1][24:0],tileX, tileY);
    sendaddrtlb(1<<24+rdaddr0_reg[1][25:6],tileX,tileY);
    for(rdport=0;rdport<16;rdport=rdport+1) begin
       if (rdaddr0_reg[47]==rdaddr0_reg[48+rdport] && rden_in_reg[48+rdport] && rden_in_reg[47]) stall=1;
    end
  end
  always @(posedge clk) if (!stall) begin
    //     wrdata_reg[0]<=wrdata; !|wren_in_reg[8]
    if (rst) stcnt=3'b1; else stcnt=stcnt+1;
    for(regcnt=1;regcnt<(48+16);regcnt=regcnt+1) begin
         waddr0_reg[regcnt]<=waddr0_reg[regcnt-1];
         wren_in_reg[regcnt]<=wren_in_reg[regcnt-1];
         wrdata_reg[regcnt]<=wrdata_reg[regcnt-1];
         rdaddr0_reg[regcnt]<=rdaddr0_reg[regcnt-1];
         rdphydata0_reg[regcnt]<=rdphydata0_reg[regcnt-1];
         rden_in_reg[regcnt]<=rden_in_reg[regcnt-1];
         rdxdata_reg[regcnt]<=rdxdata_reg[regcnt-1];
    end
   // for(wport=0;wport<36;wport=wport+1) begin
          rdaddr0_reg[0]<=rdaddr0[36:4];
          rdphydata0_reg[0]<=rdphydata0;
          waddr0_reg[0]<=wraddr0[36:4];
          rdxdata_reg[0]<=rdaddr0[3:0];
          wren_in_reg[0]<=wren_in|rden_in&rdaddr0[37];
          rden_in_reg[0]<=rden_in;
          wrdata_reg[0]<=wrdata[8*66-1:0];
          if (rden_in_reg[47] && ram_blockx[rdaddr0_reg[47][24:0]][0]||wren_in_reg[47]) wrblockx(rdaddr0_reg[47][24:0],
             {rdxdata_reg[47],wren_in_reg[47]||ram_blockx[rdaddr0_reg[47][24:0]][0]&~rdnshare},tileX,tileY);

          if (wren_in_reg[47] && !rden_in_reg[47]) wrblockwr(waddr0_reg[47][24:0],wrdata_reg[47][8*66-1:0],tileX,tileY);
          
          for(tlbptr=0;tlbptr<4;tlbptr=tlbptr+1) begin
              if (tlbdata[66*tlbptr+:17]=={1'b1,rdaddr0_reg[44][32:17]} && rden_in_reg[44]) begin
                  rdaddr0_reg[45]<={tlbdata[66*tlbptr+16+:16],rdaddr0_reg[44][16:0]};
              end
              if (tlbdata_reg[66*tlbptr+17+:16]=={rdaddr0_reg[45][32:17]} && rden_in_reg[45] && tlbdata_reg[66*tlbptr+16]) begin
                rdaddr0_xtra[tlbptr]<={tlbdata_reg[66*tlbptr+63],tlbdata_reg[66*tlbptr+:16],rdaddr0_reg[45][16:0]};
              end
              if (rdaddr0_xtra[tlbptr]==rdaddr0_rexx2) begin
                  rdaddr0_xtra_reg[0]<=rdaddr0_xtra[tlbptr];
                  rdaddr0_xtra_reg[tlbptr]<=rdaddr0_reg[46];
              end
              if (tlbdataw[66*tlbptr+:17]=={1'b1,waddr0_reg[44][32:17]} && wren_in_reg[44]) begin
                  waddr0_reg[45]<={tlbdataw[66*tlbptr+16+:16],waddr0_reg[44][16:0]};
              end
              if (tlbdataw_reg[66*tlbptr+17+:16]=={waddr0_reg[45][32:17]} && wren_in_reg[45] && tlbdataw_reg[66*tlbptr+16]) begin
                waddr0_xtra[tlbptr]<={tlbdataw_reg[66*tlbptr+63],tlbdataw_reg[66*tlbptr+:16],waddr0_reg[45][16:0]};
              end
              if (waddr0_xtra[tlbptr]==waddr0_rexx2) begin
                  waddr0_xtra_reg[0]<=waddr0_xtra[tlbptr];
                  waddr0_xtra_reg[tlbptr]<=waddr0_reg[46];
              end
              waddr0_rexx<=waddr0_reg[45];
              waddr0_rexx2<=waddr0_rexx;
              rdaddr0_rexx<=rdaddr0_reg[45];
              rdaddr0_rexx2<=rdaddr0_rexx;
              tlbdata_reg<=tlbdata;
              tlbdataw_reg<=tlbdataw;
          end 
    //end
        
  end
  
endmodule
